/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.config;

import club.iananderson.seasonhud.config.Location;
import net.minecraftforge.common.ForgeConfigSpec;

public class Config {
    public static final ForgeConfigSpec GENERAL_SPEC;
    public static ForgeConfigSpec.BooleanValue enableMod;
    public static ForgeConfigSpec.ConfigValue<Location> hudLocation;
    public static ForgeConfigSpec.ConfigValue<Integer> hudX;
    public static ForgeConfigSpec.ConfigValue<Integer> hudY;
    public static ForgeConfigSpec.BooleanValue needCalendar;
    public static ForgeConfigSpec.BooleanValue showTropicalSeason;
    public static ForgeConfigSpec.BooleanValue showSubSeason;
    public static ForgeConfigSpec.BooleanValue showDay;
    public static ForgeConfigSpec.BooleanValue showMinimapHidden;
    public static ForgeConfigSpec.BooleanValue journeyMapAboveMap;
    public static ForgeConfigSpec.BooleanValue journeyMapMacOS;

    private static void setupConfig(ForgeConfigSpec.Builder BUILDER) {
        BUILDER.push("SeasonHUD");
        enableMod = BUILDER.comment("Enable the mod?\n(true/false)\nDefault is true.").define("enable_mod", true);
        BUILDER.push("HUD");
        hudLocation = BUILDER.comment("Part of the screen to display the HUD when no minimap is installed\nDefault is \"TOP_LEFT\".").defineEnum("hud_location", (Enum)Location.TOP_LEFT);
        hudX = BUILDER.comment("The horizontal offset of the HUD when no minimap is installed (in pixels)\nDefault is 0.").define("hud_x_position", (Object)0);
        hudY = BUILDER.comment("The vertical offset of the HUD when no minimap is installed (in pixels)\nDefault is 0.").define("hud_y_position", (Object)0);
        BUILDER.pop();
        BUILDER.push("Season");
        needCalendar = BUILDER.comment("Require the Calender item to be in the players inventory to show the HUD?\n(true/false)\nDefault is false.").define("need_calendar", false);
        showTropicalSeason = BUILDER.comment("Show the Tropical seasons (Wet/Dry) in Tropical Biomes.\nWill not change the season behavior in the biomes.\n(true/false)\nDefault is true.").define("enable_show_tropical_season", true);
        showSubSeason = BUILDER.comment("Show sub-season (i.e. Early Winter, Mid Autumn, Late Spring) instead of basic season?\n(true/false)\nDefault is true.").define("enable_show_sub_season", true);
        showDay = BUILDER.comment("Show the current day of the season/sub-season?\n(true/false)\nDefault is true.").define("enable_show_day", true);
        BUILDER.pop();
        BUILDER.push("Minimap");
        showMinimapHidden = BUILDER.comment("Show the default SeasonHUD display when the minimap is hidden.\n(true/false)\nDefault is false.").define("enable_show_minimap_hidden", false);
        BUILDER.push("Journeymap");
        journeyMapAboveMap = BUILDER.comment("Show above the JourneyMap minimap, instead of below.\n(true/false)\nDefault is false.").define("enable_above_map", false);
        journeyMapMacOS = BUILDER.comment("Toggle for macOS retina display scaling when using JourneyMap.\nEnable if the season line is rendering around the halfway point of the screen.\n(true/false)\nDefault is false.").define("enable_macOS", false);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.pop();
    }

    public static void setEnableMod(boolean enableMod) {
        Config.enableMod.set((Object)enableMod);
    }

    public static void setHudLocation(Location location) {
        hudLocation.set((Object)location);
    }

    public static void setHudX(int hudX) {
        Config.hudX.set((Object)hudX);
    }

    public static void setHudY(int hudY) {
        Config.hudY.set((Object)hudY);
    }

    public static void setNeedCalendar(boolean needCalendar) {
        Config.needCalendar.set((Object)needCalendar);
    }

    public static void setShowTropicalSeason(boolean showTropicalSeason) {
        Config.showTropicalSeason.set((Object)showTropicalSeason);
    }

    public static void setShowSubSeason(boolean showSubSeason) {
        Config.showSubSeason.set((Object)showSubSeason);
    }

    public static void setShowDay(boolean showDay) {
        Config.showDay.set((Object)showDay);
    }

    public static void setShowMinimapHidden(boolean showMinimapHidden) {
        Config.showMinimapHidden.set((Object)showMinimapHidden);
    }

    public static void setJourneyMapAboveMap(boolean journeyMapAboveMap) {
        Config.journeyMapAboveMap.set((Object)journeyMapAboveMap);
    }

    public static void setJourneyMapMacOS(boolean journeyMapMacOS) {
        Config.journeyMapMacOS.set((Object)journeyMapMacOS);
    }

    static {
        ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
        Config.setupConfig(BUILDER);
        GENERAL_SPEC = BUILDER.build();
    }
}

